<?php

/**
 * @package     SP Simple Portfolio
 *
 * @copyright   Copyright (C) 2010 - 2022 JoomShaper. All rights reserved.
 * @license     GNU General Public License version 2 or later.
 */

defined('_JEXEC') or die();

use Joomla\CMS\Factory;
use Joomla\CMS\Uri\Uri;
use Joomla\CMS\Language\Text;
use Joomla\CMS\HTML\HTMLHelper;

$doc = Factory::getDocument();
$doc->addStylesheet(Uri::root(true) . '/components/com_spsimpleportfolio/assets/css/spsimpleportfolio.css');

//video
if ($this->item->video) {
	$video = parse_url($this->item->video);

	switch ($video['host']) {
		case 'youtu.be':
			$video_id 	= trim($video['path'], '/');
			$video_src 	= '//www.youtube.com/embed/' . $video_id;
			break;

		case 'www.youtube.com':
		case 'youtube.com':
			parse_str($video['query'], $query);
			$video_id 	= $query['v'];
			$video_src 	= '//www.youtube.com/embed/' . $video_id;
			break;

		case 'vimeo.com':
		case 'www.vimeo.com':
			$video_id 	= trim($video['path'], '/');
			$video_src 	= "//player.vimeo.com/video/" . $video_id;
	}
}

$client_title_condition = (isset($this->item->client) && $this->item->client);
$client_avatar_condition = (isset($this->item->client_avatar) && $this->item->client_avatar);
?>

<div id="sp-simpleportfolio" class="sp-simpleportfolio sp-simpleportfolio-view-item">
	<div class="sp-simpleportfolio-image-video-wrapper" style="background-image: url(<?php echo $this->item->image ? $this->item->image : $this->item->thumbnail; ?>);">
		<?php if($this->item->video) : ?>
			<div class="sp-simpleportfolio-embed">
				<iframe src="<?php echo $video_src; ?>" frameborder="0" webkitAllowFullScreen mozallowfullscreen allowFullScreen></iframe>
			</div>
		<?php endif; ?>
		<h2><?php echo $this->item->title; ?></h2>
	</div>

	<div class="sp-simpleportfolio-details clearfix">
		<div class="sp-simpleportfolio-info">
			<h2><?php echo $this->item->title; ?></h2>
			<div class="date-tag">
				<span>
					<?php echo HTMLHelper::_('date', $this->item->created_on, Text::_('DATE_FORMAT_LC3')); ?>
				</span>
				<span>
					<?php echo implode(', ', $this->item->tags); ?>
				</span>
			</div>
			<?php echo HTMLHelper::_('content.prepare', $this->item->description); ?>
		</div>
	</div>
</div>